package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.models.PlayingHistory;
import com.ElyStudio.leGaou.utilities.Constants;
import com.squareup.picasso.Picasso;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PlayingHistoryAdapter extends RecyclerView.Adapter<PlayingHistoryAdapter.PlayingHistoryViewHolder> {

    private Context context;
    private Activity activity;
    private List<PlayingHistory> playingHistoryList;
    private int adEnabled;
    private String nativeAdId;

    public PlayingHistoryAdapter(Context context, Activity activity, List<PlayingHistory> playingHistoryList, int adEnabled, String nativeAdId) {
        this.context = context;
        this.activity = activity;
        this.playingHistoryList = playingHistoryList;
        this.adEnabled = adEnabled;
        this.nativeAdId = nativeAdId;
    }

    public final String TAG = "PLAYING_HISTORY_ADAPTER";


    @NonNull
    @Override
    public PlayingHistoryAdapter.PlayingHistoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new PlayingHistoryViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.playing_history_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull PlayingHistoryAdapter.PlayingHistoryViewHolder holder, int position) {
        PlayingHistory playingHistory = playingHistoryList.get(position);
        Drawable playingHistoryIcon;

        if(!playingHistory.getIcon().trim().equals(""))
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL +playingHistory.getIcon()).into(holder.playingHistoryIcon);
        }
        else
        {
            if (playingHistory.getType().equals("INVITE BONUS"))
            {
                playingHistoryIcon = ContextCompat.getDrawable(context,R.drawable.invite_bonus);
            }
            else if(playingHistory.getType().equals("INVITE JOIN EARN"))
            {
                playingHistoryIcon = ContextCompat.getDrawable(context,R.drawable.invite_join_icon);
            }
            else if(playingHistory.getType().equals("DAIlY CHECK IN"))
            {
                playingHistoryIcon = ContextCompat.getDrawable(context,R.drawable.check_in_icon);
            }
            else if(playingHistory.getType().equals("AD REWARD"))
            {
                playingHistoryIcon = ContextCompat.getDrawable(context,R.drawable.ad_icon);
            }
            else if (playingHistory.getType().equals("WITHDRAW"))
            {
                playingHistoryIcon = ContextCompat.getDrawable(context,R.drawable.ic_wallet);
            }
            else
            {
                playingHistoryIcon = ContextCompat.getDrawable(context,R.drawable.coin_icon);
            }

            holder.playingHistoryIcon.setImageDrawable(playingHistoryIcon);
        }

        holder.playingActivity.setText(playingHistory.getActivity());
        int isPaid = playingHistory.getPaid() == 1 ? context.getResources().getColor(R.color.error) : context.getResources().getColor(R.color.success);
        char coinSign = playingHistory.getPaid() == 1 ? '-' : '+';
        holder.playingCoins.setText(coinSign+String.valueOf(playingHistory.getCoins()));
        holder.playingCoins.setTextColor(isPaid);
        Date date = new Date(Long.parseLong(playingHistory.getDate()) * 1000);
        String formattedDate = new SimpleDateFormat("d MMM yyyy, hh:mm aaa", Locale.getDefault()).format(date);
        holder.playingTime.setText(formattedDate);

        int p = holder.getAdapterPosition() % 5;
        if(p <= 0)
        {
            holder.adLayout.setVisibility(View.VISIBLE);
            loadNativeAd(nativeAdId,holder.adLayout);
        }
        else
        {
            holder.adLayout.setVisibility(View.GONE);
        }


    }

    @Override
    public int getItemCount() {
        return playingHistoryList.size();
    }

    public static class PlayingHistoryViewHolder extends RecyclerView.ViewHolder {
        ImageView playingHistoryIcon;
        TextView playingActivity,playingTime,playingCoins;
        FrameLayout adLayout;
        public PlayingHistoryViewHolder(@NonNull View itemView) {
            super(itemView);

            playingHistoryIcon = itemView.findViewById(R.id.playingHistoryIcon);
            playingActivity = itemView.findViewById(R.id.playingActivity);
            playingTime = itemView.findViewById(R.id.playingTime);
            playingCoins = itemView.findViewById(R.id.playingCoins);
            adLayout = itemView.findViewById(R.id.smallAdPlaceHolder);

        }
    }
    public void populateNativeAd(NativeAd nativeAd,NativeAdView nativeAdView){

        nativeAdView.setIconView(nativeAdView.findViewById(R.id.adIconSmall));
        nativeAdView.setHeadlineView(nativeAdView.findViewById(R.id.adHeadlineSmall));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(R.id.adCallToActionButtonSmall));
        nativeAdView.setBodyView(nativeAdView.findViewById(R.id.adBodySmall));

        if(nativeAd != null)
        {
            ((TextView) nativeAdView.getHeadlineView()).setText(nativeAd.getHeadline());

            if(nativeAd.getIcon() == null)
            {
                nativeAdView.getIconView().setVisibility(View.INVISIBLE);
            }
            else
            {
                nativeAdView.getIconView().setVisibility(View.VISIBLE);
                ((ImageView) nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            }

            if(nativeAd.getBody() == null)
            {
                nativeAdView.getBodyView().setVisibility(View.INVISIBLE);
            }
            else
            {
                nativeAdView.getBodyView().setVisibility(View.VISIBLE);
                ((TextView) nativeAdView.getBodyView()).setText(nativeAd.getBody());
            }

            if(nativeAd.getCallToAction() == null)
            {
                nativeAdView.getCallToActionView().setVisibility(View.INVISIBLE);
            }
            else
            {
                nativeAdView.getCallToActionView().setVisibility(View.VISIBLE);
                ((Button) nativeAdView.getCallToActionView()).setText(nativeAd.getCallToAction());
            }

            nativeAdView.setNativeAd(nativeAd);
        }


    }

    private void loadNativeAd(String nativeAdId, FrameLayout frameLayout){

        if(adEnabled == 1)
        {
            AdLoader.Builder builder = new AdLoader.Builder(context,nativeAdId);

            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener() {
                @Override
                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {

                    NativeAdView nativeAdView = (NativeAdView) activity.getLayoutInflater().inflate(R.layout.small_native_ad_layout,null);
                    if(nativeAdView == null)
                    {
                        Log.d(TAG,"NATIVE AD VIEW IS NULL");
                    }
                    populateNativeAd(nativeAd,nativeAdView);

                    frameLayout.removeAllViews();
                    frameLayout.addView(nativeAdView);
                }
            });

            AdLoader adLoader = builder.withAdListener(new AdListener() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d(TAG,"Failed to load interstitital ad = "+loadAdError);
                }
            }).build();

            adLoader.loadAd(new AdRequest.Builder().build());

        }

    }
}
